/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.config.client;

import dev.toma.configuration.config.Config;
import dev.toma.configuration.config.Configurable;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.config.client.HeldLayerSettingsConfig;
import dev.toma.gunsrpg.config.client.IHeldLayerSettings;
import dev.toma.gunsrpg.config.client.MouseInputType;
import dev.toma.gunsrpg.config.client.OpticsSensitivity;
import dev.toma.gunsrpg.config.client.QuestOverlayConfig;
import dev.toma.gunsrpg.util.math.ConfigurableVec2i;
import dev.toma.gunsrpg.util.math.IVec2i;
import net.minecraft.util.ResourceLocation;

@Config(id="gunsrpg-client", group="gunsrpg")
public final class GunsrpgConfigClient {
    @Configurable
    @Configurable.Comment(value={"Enables developer tools"})
    public boolean developerMode = false;
    @Configurable
    @Configurable.Comment(value={"Select input type for aimimg", "Values: TOGGLE, HOLD"})
    public MouseInputType aimInputType = MouseInputType.TOGGLE;
    @Configurable
    @Configurable.Comment(value={"Reflex sight reticles will be visible even when not aiming"})
    public boolean alwaysRenderReticles = false;
    @Configurable
    @Configurable.Comment(value={"Renders scope reticles differently which may help with some shaders"})
    public boolean shaderCompatibilityMode = false;
    @Configurable
    @Configurable.Comment(value={"Will render number with remaining day count to next bloodmoon on upper right corner"})
    public boolean showBloodmoonRemainingDays = true;
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=0.5)
    @Configurable.Comment(value={"Scaling of tracers"})
    @Configurable.Gui.NumberFormat(value="0.0###")
    public float tracerScale = 0.02f;
    @Configurable
    @Configurable.Comment(value={"Debuff overlay offset on HUD"})
    public IVec2i debuffOverlay = new ConfigurableVec2i(0, -60);
    @Configurable
    @Configurable.StringPattern(value="#[A-Fa-f0-9]{1,8}")
    @Configurable.Comment(value={"Color of reflex sight reticles in ARGB format"})
    @Configurable.Gui.ColorValue(isARGB=true)
    @Configurable.Gui.CharacterLimit(value=9)
    public String reticleColor = "#FFFF0000";
    @Configurable
    @Configurable.Comment(value={"Type of reticle texture", "Valid values: DOT, CHEVRON, CROSS"})
    public ReticleType reticleType = ReticleType.DOT;
    @Configurable
    @Configurable.Comment(value={"Configure held item rendering for Zombie Gunners"})
    public IHeldLayerSettings gunnerHeldItemRender = new HeldLayerSettingsConfig(IHeldLayerSettings.Mode.DEFAULT, "minecraft:crossbow");
    @Configurable
    @Configurable.Comment(value={"Configure held item rendering for Grenadiers"})
    public IHeldLayerSettings grenadierHeldItemRender = new HeldLayerSettingsConfig(IHeldLayerSettings.Mode.DEFAULT, "minecraft:bow");
    @Configurable
    @Configurable.Comment(value={"Configure sensitivity multipliers for scopes"})
    public OpticsSensitivity optics = new OpticsSensitivity();
    @Configurable
    @Configurable.Comment(value={"Configure positions of quest overlay on HUD"})
    public QuestOverlayConfig questOverlay = new QuestOverlayConfig();

    public static enum ReticleType {
        DOT("textures/icons/reticle_dot.png"),
        CHEVRON("textures/icons/reticle_chevron.png"),
        CROSS("textures/icons/reticle_cross.png");

        private final ResourceLocation path;

        private ReticleType(String path) {
            this.path = GunsRPG.makeResource(path);
        }

        public ResourceLocation getPath() {
            return this.path;
        }
    }
}

